#!/usr/bin/env python
# -*- coding: utf-8 -*-

from utils import *

import math

class View:

    def __init__(self):
        self.cms = 'a_'
        web.header("Content-Type", "text/html; charset=UTF-8")
        web.header("Cache-Control", "no-cache, must-revalidate")
        web.header("Pragma", "no-cache")

    def GET( self , prefix , p = 1):

        dic = sqlite3dbm.sshelve.open(PANEO_DB)
        scfg = dic.get('siteconfig')
        dic.close()

        sqlhub.processConnection = connectionForURI('sqlite://'+ARTICLES_DB)
        article = Articles.select(Articles.q.prefix == prefix).getOne(default=None)
        if not article :
            return web.notfound()

        article_img = {}
        for ii in range(1,6):
            file = 'article_img%s_file' % ii
            if IMG_CONV :
                src = "/img/articles/%s/article_img%s" % (prefix,ii)
            else:
                src = "/%s/articles/%s/img/article_img%s" % ( PANEO_SITE_DIR , prefix , ii )

            article_img[file] = [ os.path.exists(PANEO_SITE_DATA_DIR + "articles/%s/img/article_img%s" % (prefix,ii)) ,src ]

        img_alt = article.img
        if not img_alt :
            img_alt = {}

        rows = 10 
        p = int(p)
        results = Posts.select( Posts.q.articles == article )
        posts = results[(p-1)*rows:rows*p]
        count = results.count()
        pages = int(math.ceil(count / rows))

        return render.articles(     
                                cms = self.cms,
                                scfg = scfg, 
                                mode = 'view',
                                article = article,
                                article_img = article_img, 
                                img_alt = img_alt,
                                posts = posts,
                                count = count,
                                p = p,
                                pages = pages,
        )


class PostEdit:

    def __init__(self):
        self.cms = 'a_'
        web.header("Content-Type", "text/html; charset=UTF-8")
        web.header("Cache-Control", "no-cache, must-revalidate")
        web.header("Pragma", "no-cache")

    def GET( self , prefix , id = None):

        dic = sqlite3dbm.sshelve.open(PANEO_DB)
        scfg = dic.get('siteconfig')
        dic.close()

        sqlhub.processConnection = connectionForURI('sqlite://'+ARTICLES_DB)
        article = Articles.select(Articles.q.prefix == prefix).getOne(default=None)
        if not article :
            return web.notfound()

        post = Posts.select(Posts.q.id == id).getOne(default=None)
        if not post :
            return web.notfound()


        templates = {}
        tmps = glob.glob( PANEO_SITE_DATA_DIR + '__art__'+article.prefix+'_*.html')
        n = 0
        for f in tmps:
            fname = os.path.split(f)[1]
            name, ext = os.path.splitext(fname)
            name = name.replace('__art__','')
            names = name.split('__')
            templates[names[2]] = (n,names[0],names[1]) 
            n = n + 1

        return render.articles_post(     
                                cms = self.cms,
                                scfg = scfg, 
                                mode = 'edit',
                                article = article,
                                post = post,
                                templates = templates,
        )
